% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oxy-db_parsers.R
\name{build.LIPIDMAPS}
\alias{build.LIPIDMAPS}
\title{Build LIPID MAPS}
\usage{
build.LIPIDMAPS(outfolder, testMode = FALSE, apikey)
}
\arguments{
\item{outfolder}{Which folder to save temp files to?}

\item{testMode}{run in test mode? Only parses first ten compounds}

\item{apikey}{ChemSpider API key}
}
\value{
data table with parsed database
}
\description{
Parses the LIPID MAPS DB, returns data table with columns compoundname, description, charge, formula and structure (in SMILES)
}
\examples{
\dontrun{build.LIPIDMAPS(outfolder=tempdir(), testMode=TRUE)}
}
\seealso{
\code{\link[utils]{download.file}}
 \code{\link[zip]{unzip}}
 \code{\link[data.table]{as.data.table}},\code{\link[data.table]{fread}},\code{\link[data.table]{rbindlist}}
 \code{\link[ChemmineR]{datablock2ma}},\code{\link[ChemmineR]{datablock}}
 \code{\link[xml2]{read_xml}}
 \code{\link[rvest]{html_nodes}},\code{\link[rvest]{html_text}}
 \code{\link[stringr]{str_match}}
 \code{\link[pbapply]{pbapply}}
 \code{\link[stringi]{stri_detect}}
}
