% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oxy-db_extended.R
\name{buildExtDB}
\alias{buildExtDB}
\title{Build external database using a given base database}
\usage{
buildExtDB(
  outfolder,
  ext.dbname = "extended",
  base.dbname,
  cl = 0,
  blocksize = 600,
  mzrange = c(60, 600),
  adduct_table = adducts,
  adduct_rules = adduct_rules,
  silent = silent,
  use.rules = TRUE,
  count.isos = F,
  all.isos = T
)
}
\arguments{
\item{outfolder}{Which folder are your databases in?}

\item{ext.dbname}{Extended database name (without .db suffix), Default: 'extended'}

\item{base.dbname}{Base database name (without .db suffix)}

\item{cl}{parallel::makeCluster object for multithreading, Default: 0}

\item{blocksize}{How many compounds to process simultanaously? Higher means more memory spikes but faster building, Default: 600}

\item{mzrange}{Range of m/zs to include in database, Default: c(60, 600)}

\item{adduct_table}{Adduct table, Default: adducts}

\item{adduct_rules}{Adduct rule table, Default: adduct_rules}

\item{silent}{Silence warnings?, Default: silent}

\item{use.rules}{Use adduct rules?, Default: TRUE}

\item{count.isos}{Add columns for amounts of 2H, 13C, 15N atoms? Useful for heavy isotope experiments.}

\item{all.isos}{Include and calculate all isotopes? (if FALSE, only takes the 100/main isotope).}
}
\description{
Wrapper function that takes a base database, an existing (or not) external database, and fills the extended database with adduct and isotope variants of the compounds in the base database.
}
\examples{
 \dontrun{myFolder = tempdir()}
 \dontrun{buildBaseDB(outfolder = myFolder, "lmdb", test = TRUE)}
 \dontrun{file.remove(file.path(myFolder, "extended.db"))}
 \dontrun{data(adducts)}
 \dontrun{data(adduct_rules)}
 \dontrun{buildExtDB(outfolder = myFolder, base.dbname = "lmdb",
 silent=FALSE, adduct_table = adducts, adduct_rules = adduct_rules)}
}
\seealso{
\code{\link[RSQLite]{SQLite}}
 \code{\link[gsubfn]{fn}}
 \code{\link[data.table]{as.data.table}},\code{\link[data.table]{rbindlist}},\code{\link[data.table]{fwrite}},\code{\link[data.table]{fread}}
 \code{\link[DBI]{dbWriteTable}}
 \code{\link[pbapply]{pbapply}}
 \code{\link[enviPat]{check_chemform}}
}
