% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oxy-db_extended.R
\name{countAdductRuleMatches}
\alias{countAdductRuleMatches}
\title{Check which structures are OK according to given adduct rules}
\usage{
countAdductRuleMatches(iatoms, adduct_rules)
}
\arguments{
\item{iatoms}{Iatomcontainers with compounds}

\item{adduct_rules}{Adduct rule table (default is data(adduct_rules))}
}
\value{
Table with all structures and if they pass the rules given for each adduct
}
\description{
Calculate 'rules' for all compounds (requires iatom-ization)
}
\examples{
 iatom = smiles.to.iatom(c('OC[C@H]1OC(O)[C@H](O)[C@H](O)[C@H]1O'))
 data(adduct_rules)
 addScore <- countAdductRuleMatches(iatom, adduct_rules = adduct_rules)
}
\seealso{
\code{\link[rcdk]{matches}},\code{\link[rcdk]{get.total.formal.charge}}
}
