% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build.R
\name{c_net_set}
\alias{c_net_set}
\title{Set basic attributes from totu table}
\usage{
c_net_set(
  go,
  ...,
  vertex_group = "v_group",
  vertex_class = "v_class",
  vertex_size = "size",
  edge_type = "e_type",
  edge_class = "e_class",
  edge_width = "width",
  node_break = 5,
  edge_break = 5
)
}
\arguments{
\item{go}{metanet an igraph object}

\item{...}{some data.frames to annotate go}

\item{vertex_group}{choose which column to be vertex_group (map to vertex_shape)}

\item{vertex_class}{choose which column to be vertex_class (map to vertex_color)}

\item{vertex_size}{choose which column to be vertex_size (map to vertex_size)}

\item{edge_type}{choose which column to be edge_type (map to edge_color)}

\item{edge_class}{choose which column to be edge_class (map to edge_linetype)}

\item{edge_width}{choose which column to be edge_width (map to edge_width)}

\item{node_break}{node_break if v_class is numeric, default: 5}

\item{edge_break}{edge_break if e_type is numeric, default: 5}
}
\value{
a metanet object
}
\description{
Set basic attributes from totu table
}
\examples{
data("otutab", package = "pcutils")
t(otutab) -> totu
metadata[, 3:10] -> env

data("c_net")
co_net <- c_net_set(co_net, taxonomy, data.frame("Abundance" = colSums(totu)),
    vertex_class = "Phylum", vertex_size = "Abundance"
)
co_net2 <- c_net_set(co_net2, taxonomy, data.frame(name = colnames(env), env = colnames(env)),
    vertex_class = c("Phylum", "env")
)
co_net2 <- c_net_set(co_net2, data.frame("Abundance" = colSums(totu)), vertex_size = "Abundance")
}
