\name{rainman}
\alias{rainman}
\docType{data}
\title{Perception of points in a swarm}
\description{
  Five raters were asked to guess the number of points in a swarm for 10
  different figures (which - unknown to the raters - were each repeated
  three times).
}
\usage{data(rainman)}
\format{
  A data frame with 30 observations on the following 6 variables.
  \describe{
    \item{\code{SAND}}{The true number of points in the swarm. Each
      picture is replicated thrice}
    \item{\code{ME}}{Ratings from judge 1}
    \item{\code{TM}}{Ratings from judge 2}
    \item{\code{AJ}}{Ratings from judge 3}
    \item{\code{BM}}{Ratings from judge 4}
    \item{\code{LO}}{Ratings from judge 5}
  }
}
\details{
The raters had approximately 10 seconds to judge each picture, and they
thought it were 30 different pictures. Before starting the experiment
they were shown 6 (unrelated) pictures and were told the number of
points in each of those pictures. The SAND column contains the picture
id (which is also the true number of points in the swarm).
}
\source{
Collected by Claus Ekstrom.
}
\examples{
library(MethComp)
data( rainman )
str( rainman )
RM <- Meth( rainman, item=1, y=2:6 )
head( RM )
BA.est( RM, linked=FALSE )
library(lme4)
mf <- lmer( y ~ meth + item + (1|MI),
                data = transform( RM, MI=interaction(meth,item) ) )
summary( mf )
mr <- lmer( y ~ (1|meth) + (1|item) + (1|MI),
                data = transform( RM, MI=interaction(meth,item) ) )
summary( mr )

#
# Point swarms were generated by the following program
#
\dontrun{
set.seed(2) # Original
npoints <- sample(4:30)*4
nplots <- 10
pdf(file="swarms.pdf", onefile=TRUE)

s1 <- sample(npoints[1:nplots])
print(s1)
for (i in 1:nplots) {
  n <- s1[i]
  set.seed(n)
  x <- runif(n)
  y <- runif(n)
  plot(x,y, xlim=c(-.15, 1.15), ylim=c(-.15, 1.15), pch=20, axes=F,
       xlab="", ylab="")
}
s1 <- sample(npoints[1:nplots])
print(s1)
for (i in 1:nplots) {
  n <- s1[i]
  set.seed(n)
  x <- runif(n)
  y <- runif(n)
  plot(y,x, xlim=c(-.15, 1.15), ylim=c(-.15, 1.15), pch=20, axes=F,
       xlab="", ylab="")
}
s1 <- sample(npoints[1:nplots])
print(s1)
for (i in 1:nplots) {
  n <- s1[i]
  set.seed(n)
  x <- runif(n)
  y <- runif(n)
  plot(-x,y, xlim=c(-1.15, .15), ylim=c(-.15, 1.15), pch=20, axes=F,
       xlab="", ylab="")
}
dev.off()
}
}
\keyword{datasets}
