% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measure_compare.R
\name{measure_compare}
\alias{measure_compare}
\title{Estimation of the amount of bias of a new measurement method relative to a
reference method with possibly heteroscedastic errors}
\usage{
measure_compare(data, new = "y1", Ref = "y2", ID = "id")
}
\arguments{
\item{data}{a dataframe containing the identification number of the subject (id),
the measurement values from the new measurement method (y1) and those
from the reference methods).}

\item{new}{specify the variable name or location of the new measurement method}

\item{Ref}{specify the variable name or location of the reference standard}

\item{ID}{specify the variable name for location of the subject identification
number}
}
\value{
The function return a list with the following iterms:

\itemize{
  \item Bias: differential and proportional bias for new method and the
  associated 95 percent confidence intervals
  \item Models: list of models fitted in estimation procedure
  \item Ref: a data frame containing the various variables used to
  compute the bias and precision plots, as well the smooth standard errors
  estimates of the reference standard
  \item New: a data frame containing the various variables used to compute
  the bias and precision plots, as well the smooth standard errors estimates
   of the new measurement method
}
}
\description{
This function implements the methodology reported in the paper entitled
"Effective plots to assess bias and precision in method comparison studies"
published in Statistical Methods in
Medical Research (P. Taffe, 2015) (to appear).
}
\details{
This functions implements the new estimation procedure to assess the
agreement between the two measurement methods, as well as
Bland & Altman's limits of agreement extended to the setting of
possibly heteroscedastic measurement errors.
}
\examples{
### Load the data
data(data1)
### Analysis
measure_model <- measure_compare(data1)
}
\author{
Mingkai Peng
}

