% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/murphy_diagram.R
\name{murphy_diagram}
\alias{murphy_diagram}
\title{Murphy diagram}
\usage{
murphy_diagram(
  actual,
  predicted,
  w = NULL,
  alpha = 0.5,
  theta = seq(-2, 2, length.out = 100),
  functional = c("expectile", "quantile"),
  plot = TRUE,
  ...
)
}
\arguments{
\item{actual}{Observed values.}

\item{predicted}{Predicted values.}

\item{w}{Optional case weights.}

\item{alpha}{Level of expectile resp. quantile. The default \code{alpha = 0.5} corresponds to the expectation resp. median.}

\item{theta}{Vector of evaluation points.}

\item{functional}{Either "expectile" or "quantile".}

\item{plot}{Should plot (\code{TRUE}) be returned or the data to be plotted?}

\item{...}{Further arguments passed to \code{plot}.}
}
\value{
A named list of functions.
}
\description{
Murphy diagram of the elementary scoring function for expectiles resp. quantiles at level \code{alpha} for different values of \code{theta}.
Can be used to study and compare performance of one or multiple models. If the plot needs to be customized, set \code{plot = FALSE} to get the resulting data instead of the plot.
}
\examples{
y <- 1:10
predicted <- 1.1 * y
murphy_diagram(y, predicted, theta = seq(0.9, 1.2, by = 0.01))
two_models <- cbind(m1 = predicted, m2 = 1.2 * y)
murphy_diagram(y, two_models, theta = seq(0.9, 1.3, by = 0.01))
}
\references{
Ehm, W., Gneiting, T., Jordan, A. and Krüger, F. (2016), Of quantiles and expectiles: consistent scoring functions, Choquet representations and forecast rankings. J. R. Stat. Soc. B, 78: 505-562, <doi.org/10.1111/rssb.12154>.
}
\seealso{
\code{\link{elementary_score}}.
}
