% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humans_MOI.R
\name{compute_x.MOI}
\alias{compute_x.MOI}
\title{Compute net infectiousness for MOI model (\eqn{x})}
\usage{
\method{compute_x}{MOI}(model)
}
\arguments{
\item{model}{an object from \link{make_MicroMoB}}
}
\value{
a vector of length \code{n} giving the net infectiousness of human hosts in each stratum
}
\description{
In the simple MOI (queueing) model here (M/M/inf), net infectiousness
is considered not to vary with increasing MOI. It is calculated as
\deqn{c \cdot (1 - \frac{X_{0}}{H})}
where \eqn{X_{0}} is the number of uninfected persons (multiplicity of infection of zero).
}
