% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aquatic_BH.R
\name{get_config_aqua_BH}
\alias{get_config_aqua_BH}
\title{Get parameters for aquatic (immature) model with Beverton-Holt dynamics}
\usage{
get_config_aqua_BH(path)
}
\arguments{
\item{path}{a file path to a JSON file}
}
\value{
a named \link{list}
}
\description{
The JSON config file should have two entries:
\itemize{
\item stochastic: a boolean value
\item molt: a scalar, vector, or matrix (row major)
\item surv: a scalar, vector, or matrix (row major)
\item K: a scalar, vector, or matrix (row major)
\item L: a vector
}

Please see \link{time_patch_varying_parameter} for allowed dimensions of entries
\code{molt}, \code{surv}, and \code{K}. \code{L} should be of length equal to the number of patches.
For interpretation of the entries, please read \link{setup_aqua_BH}.
}
\examples{
# to see an example of proper JSON input, run the following
library(jsonlite)
p <- 5 # number of patches
t <- 10 # number of days to simulate
par <- list(
 "stochastic" = FALSE,
 "molt" = 0.3,
 "surv" = rep(0.5, 365),
 "K" = matrix(rpois(n = t * p, lambda = 100), nrow = p, ncol = t),
 "L" = rep(10, p)
)
toJSON(par, pretty = TRUE)
}
