% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blast.R
\name{blast_to_derep}
\alias{blast_to_derep}
\title{Blast some sequence against sequences from of a \code{\link[dada2]{derep-class}}
object.}
\usage{
blast_to_derep(
  derep,
  seq2search,
  blastpath = NULL,
  id_cut = 90,
  bit_score_cut = 50,
  min_cover_cut = 50,
  e_value_cut = 1e-30,
  unique_per_seq = FALSE,
  score_filter = FALSE,
  list_no_output_query = FALSE,
  min_length_seq = 200,
  args_makedb = NULL,
  args_blastn = NULL,
  nproc = 1,
  keep_temporary_files = FALSE
)
}
\arguments{
\item{derep}{The result of \code{dada2::derepFastq()}. A list of \code{derep-class}
object.}

\item{seq2search}{(required) path to a fasta file defining the sequences
you want to blast against the taxa (ASV, OTU) sequences from the physeq object.}

\item{blastpath}{path to blast program}

\item{id_cut}{(default: 90) cut of in identity percent to keep result}

\item{bit_score_cut}{(default: 50) cut of in bit score to keep result
The higher the bit-score, the better the sequence similarity.
The bit-score is the requires size of a sequence database in which the current
match could be found just by chance. The bit-score is a log2 scaled and
normalized raw-score. Each increase by one doubles the required database size
(2bit-score).}

\item{min_cover_cut}{(default: 50) cut of in query cover (\%) to keep result}

\item{e_value_cut}{(default: 1e-30)  cut of in e-value (\%) to keep result
The BLAST E-value is the number of expected hits of similar quality (score)
that could be found just by chance.}

\item{unique_per_seq}{(logical, default FALSE) if TRUE only return the better match
(higher \strong{bit score}) for each sequence}

\item{score_filter}{(logical, default TRUE) does results are filter by score? If
FALSE, \code{id_cut},\code{bit_score_cut}, \code{e_value_cut} and \code{min_cover_cut} are ignored}

\item{list_no_output_query}{(logical) does the result table include
query sequences for which \code{blastn} does not find any correspondence?}

\item{min_length_seq}{(default: 200) Removed sequences with less than
\code{min_length_seq} from derep before blast. Set to 0 to discard filtering
sequences by length.}

\item{args_makedb}{Additional parameters parse to makeblastdb command}

\item{args_blastn}{Additional parameters parse to blastn command}

\item{nproc}{(default: 1)
Set to number of cpus/processors to use for blast (args -num_threads
for blastn command)}

\item{keep_temporary_files}{(logical, default: FALSE) Do we keep temporary
files :
\itemize{
\item db.fasta (refseq transformed into a database)
\item dbase list of files (output of blastn)
\item blast_result.txt the summary result of blastn using
\verb{-outfmt "6 qseqid qlen sseqid slen length pident evalue bitscore qcovs"}
}}
}
\value{
A blast table
}
\description{
\if{html}{\out{
<a href="https://adrientaudiere.github.io/MiscMetabar/articles/Rules.html#lifecycle">
<img src="https://img.shields.io/badge/lifecycle-experimental-orange" alt="lifecycle-experimental"></a>
}}


Use the blast software.
}
\seealso{
\code{\link[=blast_pq]{blast_pq()}} to use \code{refseq} slot as query sequences
against un custom database and \code{\link[=blast_to_phyloseq]{blast_to_phyloseq()}}  to use
\code{refseq} slot as a database
}
\author{
Adrien Taudière
}
