% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/controls.R
\name{subset_taxa_tax_control}
\alias{subset_taxa_tax_control}
\title{Subset taxa using a taxa control (e.g. truffle root tips) through 3 methods.}
\usage{
subset_taxa_tax_control(
  physeq,
  taxa_distri,
  method = "mean",
  min_diff_for_cutoff = NULL
)
}
\arguments{
\item{physeq}{(required): a \code{\link{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{taxa_distri}{(required) a vector of length equal to the number of
samples with the number of sequences per samples for the taxa control}

\item{method}{(default: "mean") a method to calculate the cut-off value.
There is 6 available methods:
\enumerate{
\item \code{cutoff_seq}: discard taxa with less than the number of sequence
than taxa control,
\item \code{cutoff_mixt}: using mixture models,
\item \code{cutoff_diff}: using a minimum difference threshold
(need the argument min_diff_for_cutoff)
\item \code{min}: the minimum of the three firsts methods
\item \code{max}: the maximum of the three firsts methods
\item \code{mean}: the mean of the three firsts methods
}}

\item{min_diff_for_cutoff}{(int) argument for method \code{cutoff_diff}.
Required if method is \code{cutoff_diff}, \code{min}, \code{max} or \code{mean}}
}
\value{
A new \code{\link{phyloseq-class}} object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{


subset_taxa_tax_control(data_fungi,
  as.numeric(data_fungi@otu_table[, 300]),
  min_diff_for_cutoff = 2
)

}
\author{
Adrien Taudière
}
