% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dada_phyloseq.R
\name{tbl_sum_samdata}
\alias{tbl_sum_samdata}
\title{Summarize information from sample data in a table}
\usage{
tbl_sum_samdata(physeq, remove_col_unique_value = TRUE, ...)
}
\arguments{
\item{physeq}{(required): a \code{\link[phyloseq]{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{remove_col_unique_value}{(logical, default TRUE) Do we remove
informative columns (categorical column with one value per samples),
e.g. samples names ?}

\item{...}{Other arguments pass on to \code{\link[gtsummary:tbl_summary]{gtsummary::tbl_summary()}}.}
}
\value{
A new \code{\link[phyloseq]{phyloseq-class}} object with a larger slot tax_table
}
\description{
\if{html}{\out{
<a href="https://adrientaudiere.github.io/MiscMetabar/articles/Rules.html#lifecycle">
<img src="https://img.shields.io/badge/lifecycle-experimental-orange" alt="lifecycle-experimental"></a>
}}


A wrapper for the \code{\link[gtsummary:tbl_summary]{gtsummary::tbl_summary()}} function in the case of \code{physeq}
object.
}
\details{
This function is mainly a wrapper of the work of others.
Please make a reference to \code{gtsummary::tbl_summary()} if you
use this function.
}
\examples{
if (requireNamespace("gtsummary")) {
  tbl_sum_samdata(data_fungi) \%>\%
    gtsummary::as_kable()

  summary_samdata <- tbl_sum_samdata(data_fungi,
    include = c("Time", "Height"),
    type = list(Time ~ "continuous2", Height ~ "categorical"),
    statistic = list(Time ~ c("{median} ({p25}, {p75})", "{min}, {max}"))
  )
}
\donttest{
data(enterotype)
if (requireNamespace("gtsummary")) {
  summary_samdata <- tbl_sum_samdata(enterotype)
  summary_samdata <- tbl_sum_samdata(enterotype, include = !contains("SampleId"))
}
}
}
\author{
Adrien Taudière
}
