% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MissCP.R
\name{BTIE}
\alias{BTIE}
\title{BTIE}
\usage{
BTIE(
  data_y,
  lambda.1.cv = NULL,
  lambda.2.cv = NULL,
  max.iteration = 100,
  tol = 10^(-2),
  block.size = NULL,
  refit = FALSE,
  optimal.block = TRUE,
  optimal.gamma.val = 1.5,
  block.range = NULL
)
}
\arguments{
\item{data_y}{input data matrix (response), with each column representing the time series component}

\item{lambda.1.cv}{tuning parmaeter lambda_1 for fused lasso}

\item{lambda.2.cv}{tuning parmaeter lambda_2 for fused lasso}

\item{max.iteration}{max number of iteration for the fused lasso}

\item{tol}{tolerance for the fused lasso}

\item{block.size}{the block size}

\item{refit}{logical; if TRUE, refit the model, if FALSE, use BIC to find a thresholding value and then output the parameter estimates without refitting. Default is FALSE.}

\item{optimal.block}{logical; if TRUE, grid search to find optimal block size, if FALSE, directly use the default block size. Default is TRUE.}

\item{optimal.gamma.val}{hyperparameter for optimal block size, if optimal.blocks == TRUE. Default is 1.5.}

\item{block.range}{the search domain for optimal block size.}
}
\value{
A list object, which contains the followings
}
\description{
Perform the BTIE algorithm to detect the structural breaks
in large scale high-dimensional mean shift models.
}
\examples{
set.seed(1)
n <- 1000;
p <- 50;
brk <-  c(333, 666, n+1)
m <- length(brk)
d <- 5
constant.full <- constant_generation(n, p, d, 50, brk)
e.sigma <- as.matrix(1*diag(p))
data_y <- data_generation(n = n, mu = constant.full, sigma = e.sigma, brk = brk)
data_y <- as.matrix(data_y, ncol = p.y)
data_y_miss <- MCAR(data_y, 0.3)
temp <- BTIE(data_y_miss, optimal.block = FALSE, block.size = 30)
temp$cp.final
}
