% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_source_data.R
\name{load_source_data}
\alias{load_source_data}
\title{Load source data}
\usage{
load_source_data(filename, source_factors = NULL, conc_dep, data_type, mix)
}
\arguments{
\item{filename}{character, csv file with the source data.}

\item{source_factors}{character, column heading in 'filename' that matches
a Fixed or Random Effect from the mixture data (\code{mixsiar$mix$factors}).
Only used if you have source data by a factor (e.g. "Region"), otherwise \code{NULL}.}

\item{conc_dep}{T/F, \code{TRUE} indicates you have concentration dependence
data in 'filename'.}

\item{data_type}{\code{"raw"} or \code{"means"}. "Raw" source data are repeated
source biotracer measurements, "means" data are source biotracer values as
means, SDs, and sample size. See manual for formatting.}

\item{mix}{list, output from \code{\link{load_mix_data}}.}
}
\value{
\code{source}, a list including:
\itemize{
  \item \code{source$n.sources}: integer, number of sources
  \item \code{source$source_names}: vector, source names/labels
  \item \code{source$S_MU}: matrix, source means used for plotting - NOT
  passed to JAGS. If sources are by factor, then the third column of S_MU
  will be the factor values (e.g. for 4 sources and 3 Regions:
  1 2 3 1 2 3 1 2 3 1 2 3)
  \item \code{source$S_SIG}: matrix, source SDs used for plotting - NOT passed
   to JAGS. Same structure as S_MU.
  \item \code{source$S_factor1}: factor or NULL, factor values if sources are
   by factor.
  \item \code{source$S_factor_levels}: scalar or NULL, number of \code{S_factor1}
   levels if sources are by factor.
  \item \code{source$conc}: matrix or NULL, concentration dependence values
  for each isotope
  \item \code{source$MU_array}: array of source means, dim(src,iso,f1) or
  dim(src,iso) if data_type="means", NULL if data_type="raw".
  \item \code{source$SIG2_array}: array of source variances, dim(src,iso,f1)
  or dim(src,iso) if data_type="means", NULL if data_type="raw".
  \item \code{source$n_array}: vector/matrix of source sample sizes,
  dim(src,f1) or dim(src) if data_type="means", NULL if data_type="raw".
  \item \code{source$SOURCE_array}: array of source data, dim(src,iso,f1,replicate)
   or dim(src,iso,replicate) if data_type="raw", NULL if data_type="means".
  \item \code{source$n.rep}: vector/matrix of source sample sizes, dim(src,f1)
   or dim(src) if data_type="raw", NULL if data_type="means".
  \item \code{source$by_factor}: NA or factor number, are the source data by a Fixed or Random Effect?
  \item \code{source$data_type}: \code{"raw"} or \code{"means"}, same as input.
  \item \code{source$conc_dep}: T/F, same as input.
}
}
\description{
\code{load_source_data} specifies the source data structure (factors,
concentration dependence, data type) and loads the source data file. \emph{Sources
are sorted alphabetically.}
}
\details{
WARNING messages check for:
\itemize{
 \item More than one source factor selected
 \item Source factor not in mixture data
 \item Source sample sizes missing or entered incorrectly
 \item Source SD = 0
}
}
\seealso{
\code{\link{load_mix_data}} and \code{\link{load_discr_data}}
}

