% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3_coreFunctions.R
\name{createProcessState}
\alias{createProcessState}
\title{createProcessState}
\usage{
createProcessState(elements, dependentVariable)
}
\arguments{
\item{elements}{A named list of the outcome variable (edgelist), the nodesets,
and all covariates that contain the information about the data that will be
used in the estimation.}

\item{dependentVariable}{The name of the outcome variable (edgelist) as
specified under "elements". This indicates what outcome
the researcher is interested in.}
}
\value{
An object of class "processState.monan".
}
\description{
Creates the "Process state", i.e., a MoNAn object that stores all information
about the data that will be used in the estimation. This includes the
outcome variable (edgelist), the nodesets, and all covariates.
}
\examples{
# Create a process state out of the mobility data objects:
# create objects (which are later combined to the process state)
transfers <- createEdgelist(mobilityEdgelist,
  nodeSet = c("organisations", "organisations", "people")
)
people <- createNodeSet(1:nrow(mobilityEdgelist))
organisations <- createNodeSet(1:length(orgRegion))
sameRegion <- outer(orgRegion, orgRegion, "==") * 1
sameRegion <- createNetwork(sameRegion,
  nodeSet = c("organisations", "organisations")
)
region <- createNodeVariable(orgRegion, nodeSet = "organisations")
size <- createNodeVariable(orgSize, nodeSet = "organisations", addSim = TRUE)
sex <- createNodeVariable(indSex, nodeSet = "people")

# combine created objects to the process state
myState <- createProcessState(list(
    transfers = transfers,
    people = people,
    organisations = organisations,
    sameRegion = sameRegion,
    region = region,
    size = size,
    sex = sex),
  dependentVariable = "transfers")
}
\seealso{
\code{\link[=createEdgelist]{createEdgelist()}}, \code{\link[=createNodeSet]{createNodeSet()}},
\code{\link[=createNodeVariable]{createNodeVariable()}}, \code{\link[=createNetwork]{createNetwork()}}
}
