% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/structuralLearning.R
\name{getChildParentsFromGraph}
\alias{getChildParentsFromGraph}
\title{Get Relationships in a Network}
\usage{
getChildParentsFromGraph(graph, nameVars = NULL)
}
\arguments{
\item{graph}{A structural network of the class \code{"graphNEL"},
\code{"network"} or \code{"bn"}.}

\item{nameVars}{A character array giving the names of the variables in the graph. By default it's NULL,
only put it when a graph of class \code{"network"} is used.}
}
\value{
A list of elements. Each element contains a vector with the name of a child
and their parents.
}
\description{
Extract the relationship between the variables of a dataset using
the obtained network
}
\examples{
## Data
data(ecoli)
ecoli <- ecoli[,-1] ## Sequence Name

## DAG1
dag1 <- LearningHC(ecoli)
dag1
plot(dag1)
getChildParentsFromGraph(dag1)

## DAG2
dag2 <- LearningHC(ecoli, numIntervals = 10)
dag2
plot(dag2)
getChildParentsFromGraph(dag2)
}

