% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/rescalatedFunctions.R
\name{rescaledFunctions}
\alias{ToStringRe_MOP}
\alias{ToStringRe_MTE}
\alias{meanMOP}
\alias{rescaledFunctions}
\alias{rescaledMOP}
\alias{rescaledMTE}
\alias{rescaledMoTBFs}
\title{Rescales an MoTBF Function}
\usage{
rescaledMoTBFs(fx, data)

rescaledMOP(fx, data)

ToStringRe_MOP(parameters, data)

rescaledMTE(fx, data)

ToStringRe_MTE(parameters, data, num = 5)

meanMOP(fx)
}
\arguments{
\item{fx}{A function of class \code{"motbf"} learned from a scaled data.}

\item{data}{A \code{"numeric"} vector containing the original data without being scaled.}

\item{parameters}{A \code{"numeric"} vector with the coefficients to create the rescaled MoTBF.}

\item{num}{A \code{"numeric"} value which contains the denominator of the coefficient
in the exponential. By default it is 5.}
}
\value{
An \code{"motbf"} function of the original data.
}
\description{
A collation of function to reescale an MoTBF function
to the original limits and scale.
}
\examples{
## 1. EXAMPLE
X <- rchisq(1000, df = 8) ## data
modX <- scale(X) ## scale data

## Learning
f <- univMoTBF(modX, POTENTIAL_TYPE = "MOP", nparam=10)
plot(f, xlim = range(modX), col=2)
hist(modX, prob = TRUE, add = TRUE)

## Rescale
origF <- rescaledMoTBFs(f, X) ## rescaledMOP(f, X)
plot(origF, xlim = range(X), col=2)
hist(X, prob = TRUE, add = TRUE)
meanMOP(origF) ## mean(X)

## 2. EXAMPLE
X <- rweibull(1000, shape = 20, scale= 10) ## data
modX <- as.numeric(scale(X)) ## scale data

## Learning
f <- univMoTBF(modX, POTENTIAL_TYPE = "MTE", nparam = 9)
plot(f, xlim = range(modX), col=2, main="")
hist(modX, prob = TRUE, add = TRUE)

## Rescale
origF <- rescaledMoTBFs(f, X) ## rescaledMTE(f, X)
plot(origF, xlim = range(X), col=2)
hist(X, prob = TRUE, add = TRUE)
}
\seealso{
\link{univMoTBF}
}

