% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearningBN.R
\name{MoTBFs_Learning}
\alias{MoTBFs_Learning}
\title{Learning MoTBFs in a Network}
\usage{
MoTBFs_Learning(graph, data, numIntervals, POTENTIAL_TYPE,
  maxParam = NULL, s = NULL, priorData = NULL)
}
\arguments{
\item{graph}{A network of the class \code{"bn"}, \code{"graphNEL"} or \code{"network"}.}

\item{data}{A datase of class \code{"data.frame"}; it can contain continuous and discrete variables.}

\item{numIntervals}{A \code{"numeric"} value indicating the maximum number of intervals in which we 
want to split the domain of the parent variables.}

\item{POTENTIAL_TYPE}{A \code{"character"} string specifying the posibles potential
types, must be one of \code{"MOP"} or \code{"MTE"}.}

\item{maxParam}{A \code{"numeric"} value which indicate the maximum number of coefficients in the function. By default it is \code{NULL}; 
if not, the output is the function which gets the best BIC with at most this number of parameters.}

\item{s}{A \code{"numeric"} coefficient which fixes the confidence of the prior knowledge 
we are going to introduce. By default it is \code{NULL}, only we must modify it if we want 
to incorporate prior information to the fits.}

\item{priorData}{Prior dataset with values of the variables we have information apriori about.
This dataset must be of \code{"data.frame"} class.}
}
\value{
A list of lists. Each list contains two elements
\item{Child}{A \code{"charater"} string which contains the name of the child variable.}
\item{functions}{A list with three elements: the name of the parents, a \code{"numeric"} vector
with the limits of the interval and the fitted function in this interval.}
}
\description{
Learn mixtures of truncated basis functions in a full hybrid network.
}
\details{
If the variable is discrete then it computes the probabilities and the size of each leaf.
}
\examples{

## Dataset Ecoli
require(MoTBFs)
data(ecoli)
data <- ecoli[,-c(1)] ## remove variable sequence

## Directed acyclic graph
dag <- LearningHC(data)

## Learning BN
intervals <- 3
potential <- "MOP"
P1 <- MoTBFs_Learning(graph = dag, data = data, numIntervals = intervals, POTENTIAL_TYPE=potential,
maxParam = 5)
printBN(P1)

 ## Learning BN
intervals <- 4
potential <- "MTE"
P2 <- MoTBFs_Learning(graph = dag, data = data, numIntervals = intervals, POTENTIAL_TYPE=potential,
maxParam = 15)
printBN(P2)


}
\seealso{
\link{printBN} and \link{ecoli}
}
