% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getModel.R
\name{GetModel}
\alias{GetModel}
\title{Get Model for Trigger Processing}
\usage{
GetModel(ID = NULL, path = NULL)
}
\arguments{
\item{ID}{integer, Model ID value determined from MobileTrigger::ListModels() output
when SelectMDL = NULL}

\item{path}{string, path to the /Models/ folder.}
}
\value{
A model into the environment
}
\description{
Function loads a model from the TRIGGER_PATH]/Models/ folder
saved as a *.Rdata file. The Model is then applied to input data collected
from an e-mail trigger via the MobileTrigger::MailTriggerInput() function
}
\examples{
\donttest{
################################
# Get Model                    #
################################
  MODELPATH <- "C:/Triggers/Models/"
  MDL <- GetModel(ID = 1, path = MODELPATH)
## To predict use:
  predict(MDL[[1]], newdata) # to get the model use the MDL[[1]]
}
}
