% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset.R
\name{armadillo.subset}
\alias{armadillo.subset}
\title{Describes data available to subset and makes subset}
\usage{
armadillo.subset(
  source_project = NULL,
  new_project = NULL,
  subset_def = NULL,
  dry_run = FALSE
)
}
\arguments{
\item{source_project}{project from which to subset data}

\item{new_project}{project to upload subset to. Will be created if it doesn't
exist.}

\item{subset_def}{R object containing subset definition created by
\code{armadillo.subset_definition()}}

\item{dry_run}{you can dry-run the function to which variables are missing}
}
\value{
missing variables provided in the subset definition
}
\description{
This automates the process of:
\enumerate{
 \item Checking what data is available to create subsets
 \item Make the subset
}
}
\examples{
\dontrun{
armadillo.subset(
  source_project = "gecko",
  new_project = "study1",
  subset_def = local_subset
)
}

}
