% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-opn-dct.R
\name{dfourier_shape}
\alias{dfourier_shape}
\title{Calculates and draws 'dfourier' shapes}
\usage{
dfourier_shape(A, B, nb.h, nb.pts = 60, alpha = 2, plot = TRUE)
}
\arguments{
\item{A}{vector of harmonic coefficients}

\item{B}{vector of harmonic coefficients}

\item{nb.h}{if \code{A} and/or \code{B} are not provided,
the number of harmonics to generate}

\item{nb.pts}{if \code{A} and/or \code{B} are not provided,
the number of points to use to reconstruct the shapes}

\item{alpha}{tThe power coefficient associated with the (usually decreasing)
amplitude of the harmonic coefficients (see \link{efourier_shape})}

\item{plot}{logical whether to plot the shape}
}
\description{
Calculates shapes based on 'Discrete cosine transforms' given harmonic coefficients
(see \link{dfourier}) or can generate some random 'dfourier' shapes.
Mainly intended to generate shapes and/or to understand how dfourier works.
}
\examples{
# some signatures
panel(coo_align(Opn(replicate(48, dfourier_shape(alpha=0.5, nb.h=6)))))
# some worms
panel(coo_align(Opn(replicate(48, dfourier_shape(alpha=2, nb.h=6)))))
}
\seealso{
Other dfourier: \code{\link{dfourier_i}},
  \code{\link{dfourier}}
}
