% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cl-handling.R
\name{rm_uncomplete}
\alias{rm_uncomplete}
\title{Remove shapes with incomplete slices}
\usage{
rm_uncomplete(x, id, by)
}
\arguments{
\item{x}{the object on which to remove uncomplete "by"}

\item{id}{of the objects, within the $fac slot}

\item{by}{which column of the $fac should objects have complete views}
}
\description{
Imagine you take three views of every object you study. Then, you can \link{slice},
\link{filter} or \link{chop} your entire dataset, do morphometrics on it,
then want to \link{combine} it. But if you have forgotten one view, or if it
was impossible to obtain, for one or more objects, combine will not work.
This function helps you to remove those ugly ducklings. See examples
}
\examples{
# we load olea
data(olea)
# we select the var Aglan since it is the only one complete
ol <- filter(olea, var == "Aglan")
# everything seems fine
table(ol$view, ol$ind)
# indeed
rm_uncomplete(ol, id="ind", by="view")

# we mess the ol object by removing a single shape
ol.pb <- slice(ol, -1)
table(ol.pb$view, ol.pb$ind)
# the counterpart has been removed with a notice
ol.ok <- rm_uncomplete(ol.pb, "ind", "view")
# now you can combine them
table(ol.ok$view, ol.ok$ind)
}
\seealso{
Other handling functions: \code{\link{arrange}},
  \code{\link{at_least}}, \code{\link{chop}},
  \code{\link{combine}}, \code{\link{dissolve}},
  \code{\link{fac_dispatcher}}, \code{\link{filter}},
  \code{\link{mutate}}, \code{\link{rescale}},
  \code{\link{rm_harm}}, \code{\link{rw_fac}},
  \code{\link{sample_frac}}, \code{\link{sample_n}},
  \code{\link{select}}, \code{\link{slice}}
}
