% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Atlas.r
\name{plotAtlas}
\alias{plotAtlas}
\title{visualize an atlas defined by createAtlas}
\usage{
plotAtlas(atlas, pt.size = NULL, alpha = 1, render = c("w", "s"),
  point = c("s", "p"), meshcol = "white", add = TRUE, legend = TRUE,
  cols = 2:5)
}
\arguments{
\item{atlas}{object of class atlas created by \code{\link{createAtlas}}.}

\item{pt.size}{size of plotted points/spheres. If \code{point="s"}.
\code{pt.size} defines the radius of the spheres. If \code{point="p"} it
sets the variable \code{size} used in \code{point3d}.}

\item{alpha}{value between 0 and 1. Sets transparency of mesh 1=opaque 0=
fully transparent.}

\item{render}{if \code{render="w"}, a wireframe will be drawn, if
\code{render="s"}, the mesh will be shaded.}

\item{point}{how to render landmarks. "s"=spheres, "p"=points.}

\item{meshcol}{color to render the atlas mesh}

\item{add}{logical: if TRUE, a new rgl window is opened.}

\item{legend}{logical: request plot of legend specifying landmark coloring.}

\item{cols}{vector containing colors for each coordinate type cols[1]=landmarks, cols[2]=patch, cols[3]=corrCurves, cols[4]=patchCurves.}
}
\value{
returns invisible vector containing \code{rgl.id} of rendered
objects.
}
\description{
visualize an atlas defined by createAtlas
}
\details{
If \code{legend=TRUE}, a plot with a legend will open where coloring of the
3D-spheres is specified.
}
\examples{

data(nose)
atlas <- createAtlas(shortnose.mesh, landmarks =
           shortnose.lm[c(1:5,20:21),], patch=shortnose.lm[-c(1:5,20:21),])
\dontrun{
plotAtlas(atlas)
}
}
\seealso{
\code{\link{placePatch}, \link{createAtlas}}
}
