% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pls2B.r
\name{plsCoVar}
\alias{plsCoVar}
\title{Get the shape changes from pls2B associated with each latent variable}
\usage{
plsCoVar(pls, i, sdx = 3, sdy = 3)
}
\arguments{
\item{pls}{output of pls2B}

\item{i}{integer: which latent variable to show. E.g. i=3 will show the changes associated with the 3rd latent variable.}

\item{sdx}{standard deviation on the xscores. sdx=3 will show the effecs of -3sd vs +3sd}

\item{sdy}{standard deviation on the yscores. sdy=3 will show the effecs of -3sd vs +3sd}
}
\value{
\item{x}{matrix/array with reconstructed x}
\item{y}{matrix/array with reconstructed y, with each prediction named accordingly: e.g. neg_x_sd_3 means the prediction of x at a score of \code{-3*sd(Xscores)}}.
}
\description{
Get the shape changes from pls2B associated with each latent variable
}
\seealso{
\code{\link{pls2B}, \link{getPLSfromScores}, \link{predictPLSfromScores}, \link{getPLSscores}, \link{predictPLSfromData},\link{svd},  \link{plsCoVarCommonShape}}
}
