% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pensionTable.R
\docType{methods}
\name{transitionProbabilities}
\alias{transitionProbabilities}
\alias{transitionProbabilities,pensionTable-method}
\title{Return all transition probabilities of the pension table (generational probabilities)}
\usage{
transitionProbabilities(object, ...)

\S4method{transitionProbabilities}{pensionTable}(object, YOB = 1982, ...,
  ages = NULL, OverallMortality = FALSE, Period = NULL,
  retirement = NULL, invalids.retire = object@invalids.retire,
  as.data.frame = TRUE)
}
\arguments{
\item{object}{A pension table object (instance of a \code{\linkS4class{pensionTable}} class)}

\item{...}{Currently unused}

\item{YOB}{Year of birth}

\item{ages}{Desired age range (if NULL, the probabilities of the age range provided by the table will be returned), missing ages will be filled with NA}

\item{OverallMortality}{Whether the overall mortality should be returned for actives, or the active mortality}

\item{Period}{Observation year to calculate period transition probabilities.
If given, this arguments overrides the \code{YOB} parameter
and this function returns period transition probabilities.
If this argument is not given or is null, then this function
returns generational transition probabilities.}

\item{retirement}{Override the retirement transition probabilities of the
pension table. Possible values are:\itemize{
  \item Single age (describing a deterministric retirement at the given age)
  \item mortalityTable object: transition probabilities for retirement
}}

\item{invalids.retire}{Override the \code{\linkS4class{pensionTable}}'s
\code{invalids.retire} flag, which indicates whether
invalids retire like actives (i.e. same death
probabilities after retirement) or stay invalid until
death.}

\item{as.data.frame}{Whether the return value should be a data.frame or an
array containing transition matrices}
}
\description{
Return all transition probabilities of the pension table (generational probabilities)
}
\section{Methods (by class)}{
\itemize{
\item \code{pensionTable}: Return all transition probabilities of the pension table for the generation YOB
}}

\examples{
pensionTables.load("USA_PensionPlans")
transitionProbabilities(RP2014.male, YOB = 1962)
transitionProbabilities(RP2014.male, Period = 1955)
transitionProbabilities(RP2014.male, Period = 2025)

}
