% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilityFunctions.R
\name{pT.calculateTotalMortality}
\alias{pT.calculateTotalMortality}
\alias{pT.recalculateTotalMortality}
\title{Calculate the total mortality of the pension table}
\usage{
pT.calculateTotalMortality(object, ...)

pT.recalculateTotalMortality(object, ...)
}
\arguments{
\item{object}{a \code{pensionTable} object}

\item{...}{(unused)}
}
\description{
The function \code{pT.calculateTotalMortality} calculates the overall mortality from the mortality of actives and disabled
}
\details{
Since a pension tables describes mortalities of actives and of disabled separately,
the overall mortality is a function of these two. The function \code{pT.calculateTortalMortality}
calculates this overall mortality in a way that is consistent with the
individual transition probabilities of the pension table.

In particular, the pension table describes the mortalities of the individual
sub-populations of actives, disabled and old-age pensioners. The overall
mortality is the mortality that results when one discards the additional information
about the state and just observes deaths. Internally, the overall mortality
is calculated by starting from 10,000 actives and applying the transition dynamics
of the pension table to the sub-populations.

For a detailled description, see e.g. the documentation of the Austrian pension
table AVÖ 2018-P or the German Heubeck Table DAV 2005-G.
}
\section{Functions}{
\itemize{
\item \code{pT.recalculateTotalMortality}: Calculate the total mortality of a
pension table and assign it to the \code{qgx} slot of that table.
}}

\references{
R. Kainhofer, J. Hirz, A. Schubert. AVÖ 2018-P: Rechnungsgrundlagen für die Pensionsversicherung. Dokumentation der Pensionstafel. AVÖ-Arbeitskreis Rechnungsgrundlagen, 2008. \url{https://avoe.at/rechnungsgrundlagen/pensionskassen/}
}
