% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aov.P.R
\name{aov.P}
\alias{aov.P}
\title{One-way ANOVA using permutation tests}
\usage{
aov.P(dattab, permi = NULL, be = NULL)
}
\arguments{
\item{dattab}{The table on which the ANOVA has to be done, or a vector of responses.}

\item{permi}{If dattab is a table, ignored.  If dattab is a vector, a vector of treatment labels.}

\item{be}{If dattab is a table, ignored.  If dattab is a vector, a vector of end points of blocks.  In this case, blocks must form contiguous subvectors of dattab.  If null, no blocking.}
}
\value{
A list with fields pv, the p-value obtained with the permutation tests, and tot, the total number of permutations.
}
\description{
\code{aov.P} uses permutation tests instead of classic theory tests to run a one-way or two-way ANOVA.
}
\details{
The function calls a Fortran code to perform the permutation tests and the ANOVA.  The function has to be applied directly on a cross-table of two variables.
}
