% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bootstrap.R
\name{Bootstrap}
\alias{Bootstrap}
\title{Generates the bootstrap-related outputs}
\usage{
Bootstrap(
  ModelType,
  ModelParaPE,
  NumOutPE,
  Economies,
  InputsForOutputs,
  FactorLabels,
  JLLlist,
  GVARlist,
  WishBC = FALSE,
  BRWlist = NULL,
  Folder2save = NULL,
  verbose = TRUE
)
}
\arguments{
\item{ModelType}{character. Model type to be estimated. Permissible choices: "JPS original", "JPS global", "GVAR single", "JPS multi", "GVAR multi", "JLL original", "JLL No DomUnit", "JLL joint Sigma".}

\item{ModelParaPE}{list. Point estimates of the model parameters. See outputs from \code{\link{Optimization}}.}

\item{NumOutPE}{list. Point estimates from numerical outputs. See outputs from \code{\link{NumOutputs}}.}

\item{Economies}{character vector. Names of the \code{C} economies included in the system.}

\item{InputsForOutputs}{list. Inputs for generating IRFs, GIRFs, FEVDs, GFEVDs, and Term Premia.}

\item{FactorLabels}{list. Labels for all variables present in the model, as returned by \code{\link{LabFac}}.}

\item{JLLlist}{list. Inputs for JLL model estimation (see \code{\link{JLL}}). Default is NULL.}

\item{GVARlist}{list. Inputs for GVAR model estimation (see \code{\link{GVAR}}). Default is NULL.}

\item{WishBC}{logical. Whether to estimate the physical parameter model with bias correction (see \code{\link{Bias_Correc_VAR}}). Default is FALSE.}

\item{BRWlist}{list. Inputs for bias-corrected estimation (see \code{\link{Bias_Correc_VAR}}).}

\item{Folder2save}{character. Folder path where outputs will be stored. Default saves outputs in a temporary directory.}

\item{verbose}{logical. Print progress messages. Default is TRUE.}
}
\value{
An object of class 'ATSMModelBoot' containing:
\itemize{
  \item List of model parameters for each draw
  \item List of numerical outputs (IRFs, GIRFs, FEVDs, GFEVDs) for each draw
  \item Confidence bounds for the chosen level of significance
}
}
\description{
Generates the bootstrap-related outputs
}
\section{Permissible options - Bootstrap list in \code{InputsForOutputs}}{

\itemize{
   \item \code{methodBS} : \code{"bs"} (standard bootstrap), \code{"wild"} (wild bootstrap), \code{"block"} (block bootstrap)
   \item \code{BlockLength} : required input for the block bootstrap method. Block length must be larger than 0 and smallar than the model time series dimension (\code{Td}).
   \item \code{ndraws}: number of draws. Must be a positive integer.
   \item \code{pctg} : confidence level. Must be a positive integer. Common choices are: 68, 90 and  95.
}
}

\section{Available methods}{

- \code{autoplot(object, NumOutPE, type)}
}

\examples{
\donttest{
data("ParaSetEx")
data("InpForOutEx")
data("NumOutEx")
ModelType <- "JPS original"
Economy <- "Brazil"
FacLab <- LabFac(N = 1, DomVar = "Eco_Act", GlobalVar = "Gl_Eco_Act", Economy, ModelType)

# Adjust Forecasting setting
InpForOutEx[[ModelType]]$Bootstrap <- list(
  WishBootstrap = 1, methodBS = "bs", BlockLength = 4,
  ndraws = 5, pctg = 95
)

Boot <- Bootstrap(ModelType, ParaSetEx, NumOutEx, Economy, InpForOutEx, FacLab,
  JLLlist = NULL,
  GVARlist = NULL, WishBC = FALSE, BRWlist = NULL, Folder2save = NULL, verbose = FALSE
)
}

}
