% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mdr.r
\name{mdr}
\alias{mdr}
\title{Performs a Multigroup Dimensionality Reduction (MDR) analysis in the
given multigroup data matrix.
Show MDR graphical output.}
\usage{
mdr(g, grp, data.x, c, Plot = T)
}
\arguments{
\item{g}{is the size of groups}

\item{grp}{is a vector of classes}

\item{data.x}{quantitative data set}

\item{c}{component numeric}

\item{Plot}{grafics output of MDR}
}
\value{
\strong{return an grafics} .
}
\description{
Performs a Multigroup Dimensionality Reduction (MDR) analysis in the
given multigroup data matrix.
Show MDR graphical output.
}
\examples{
sim.list<-fun.sim(g=c(50,50,50),mean1=2,d=0,sds2=c(1,1,1,1),
corr=c(0.5,0.5,0.5,0),n.var=c(30,30))

mdr(g=c(50,50,50),grp=as.factor(sim.list$grp),
data.x=sim.list$`lisx`,c=2)

}
