% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Commutators.R
\name{matr_Qplication}
\alias{matr_Qplication}
\title{Qplication Matrix}
\usage{
matr_Qplication(d, q, useSparse = FALSE)
}
\arguments{
\item{d}{dimension of a vector x}

\item{q}{power of the Kronecker product}

\item{useSparse}{TRUE or FALSE.}
}
\value{
Qplication matrix of order \eqn{d^q \times \eta_{d,q}}, see (1.30), p.15.
If \code{useSparse=TRUE} an object of the class "dgCMatrix" is produced.
}
\description{
Restores the duplicated/q-plicated  elements which are eliminated
by  matr_Elimination in a T-product of vectors of dimension d.
}
\details{
Note: since the algorithm of elimination is not unique, q-plication works together
with the function  matr_Elimination only.
}
\examples{
x<-c(1,2,3)
y<-kronecker(kronecker(x,x),x)
## Distinct elements of y
z<-as.matrix(matr_Elimination(3,3))\%*\%y
## Restore eliminated elements in z
as.vector(matr_Qplication(3,3)\%*\%z)

}
\references{
Gy. Terdik, Multivariate statistical methods - going beyond the linear,
Springer 2021, p.21, (1.31)
}
\seealso{
Other Matrices and commutators: 
\code{\link{indx_Commutator_Kmn}()},
\code{\link{indx_Commutator_Kperm}()},
\code{\link{indx_Commutator_Mixing}()},
\code{\link{indx_Commutator_Moment}()},
\code{\link{indx_Elimination}()},
\code{\link{indx_Qplication}()},
\code{\link{indx_Symmetry}()},
\code{\link{indx_UnivMomCum}()},
\code{\link{matr_Commutator_Kmn}()},
\code{\link{matr_Commutator_Kperm}()},
\code{\link{matr_Commutator_Mixing}()},
\code{\link{matr_Commutator_Moment}()},
\code{\link{matr_Elimination}()},
\code{\link{matr_Symmetry}()}
}
\concept{Matrices and commutators}
