/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.online.candidate;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.myrrix.common.collection.FastByIDMap;
import net.myrrix.common.collection.FastIDSet;
import net.myrrix.online.candidate.CandidateFilter;

public final class ExampleCandidateFilter
implements CandidateFilter {
    private final FastByIDMap<float[]> Y;
    private FastIDSet someCurrentIDs;
    private final ReadWriteLock lock;

    public ExampleCandidateFilter(FastByIDMap<float[]> Y) {
        this.Y = Y;
        this.lock = new ReentrantReadWriteLock();
        int reloadMinutes = 15;
        ScheduledExecutorService executor = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setDaemon(true).build());
        executor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                ExampleCandidateFilter.this.doLoad();
            }
        }, reloadMinutes, reloadMinutes, TimeUnit.MINUTES);
        this.doLoad();
    }

    private void doLoad() {
        FastIDSet newIDs = new FastIDSet();
        newIDs.add(1L);
        this.someCurrentIDs = newIDs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Iterator<FastByIDMap.MapEntry<float[]>>> getCandidateIterator(float[][] userVectors) {
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            Set<Iterator<FastByIDMap.MapEntry<float[]>>> set = Collections.singleton(Iterators.transform(this.someCurrentIDs.iterator(), new RetrieveEntryFunction()));
            return set;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addItem(long itemID) {
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            this.someCurrentIDs.add(itemID);
        }
        finally {
            writeLock.unlock();
        }
    }

    private final class RetrieveEntryFunction
    implements Function<Long, FastByIDMap.MapEntry<float[]>> {
        private RetrieveEntryFunction() {
        }

        @Override
        public FastByIDMap.MapEntry<float[]> apply(Long itemIDObj) {
            final long key = itemIDObj;
            final float[] value = (float[])ExampleCandidateFilter.this.Y.get(key);
            return new FastByIDMap.MapEntry<float[]>(){

                @Override
                public long getKey() {
                    return key;
                }

                @Override
                public float[] getValue() {
                    return value;
                }
            };
        }
    }
}

