/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.online.candidate;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import net.myrrix.common.collection.FastByIDMap;
import net.myrrix.common.collection.FastIDSet;
import net.myrrix.common.random.RandomManager;
import net.myrrix.online.candidate.CandidateFilter;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.util.ArithmeticUtils;
import org.apache.commons.math3.util.FastMath;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LocationSensitiveHash
implements CandidateFilter {
    private static final Logger log = LoggerFactory.getLogger(LocationSensitiveHash.class);
    static final double LSH_SAMPLE_RATIO = Double.parseDouble(System.getProperty("model.lsh.sampleRatio", "1.0"));
    private static final int NUM_HASHES = Integer.parseInt(System.getProperty("model.lsh.numHashes", "20"));
    private final FastByIDMap<float[]> Y;
    private final boolean[][] randomVectors;
    private final double[] meanVector;
    private final FastByIDMap<long[]> buckets;
    private final FastIDSet newItems;
    private final int maxBitsDiffering;

    public LocationSensitiveHash(FastByIDMap<float[]> Y) {
        Preconditions.checkNotNull(Y);
        Preconditions.checkArgument(!Y.isEmpty(), "Y is empty");
        Preconditions.checkState(LSH_SAMPLE_RATIO < 1.0);
        this.Y = Y;
        log.info("Using LSH sampling to sample about {}% of items", (Object)(LSH_SAMPLE_RATIO * 100.0));
        double denominator = FastMath.pow(2.0, NUM_HASHES);
        int bitsDiffering = -1;
        for (double cumulativeProbability = 0.0; bitsDiffering < NUM_HASHES && cumulativeProbability < LSH_SAMPLE_RATIO; cumulativeProbability += ArithmeticUtils.binomialCoefficientDouble(NUM_HASHES, ++bitsDiffering) / denominator) {
        }
        this.maxBitsDiffering = bitsDiffering - 1;
        log.info("Max bits differing: {}", (Object)this.maxBitsDiffering);
        int features = Y.entrySet().iterator().next().getValue().length;
        RandomGenerator random = RandomManager.getRandom();
        for (boolean[] randomVector : this.randomVectors = new boolean[NUM_HASHES][features]) {
            for (int j = 0; j < features; ++j) {
                randomVector[j] = random.nextBoolean();
            }
        }
        this.meanVector = LocationSensitiveHash.findMean(Y, features);
        this.buckets = new FastByIDMap(1000, 1.25f);
        int count = 0;
        int maxBucketSize = 0;
        for (FastByIDMap.MapEntry<float[]> entry : Y.entrySet()) {
            long signature = this.toBitSignature(entry.getValue());
            long[] ids = this.buckets.get(signature);
            if (ids == null) {
                this.buckets.put(signature, new long[]{entry.getKey()});
            } else {
                int length = ids.length;
                long[] newIDs = new long[length + 1];
                for (int i = 0; i < length; ++i) {
                    newIDs[i] = ids[i];
                }
                newIDs[length] = entry.getKey();
                maxBucketSize = FastMath.max(maxBucketSize, newIDs.length);
                this.buckets.put(signature, newIDs);
            }
            if (++count % 1000000 != 0) continue;
            log.info("Bucketed {} items", (Object)count);
        }
        log.info("Max bucket size {}", (Object)maxBucketSize);
        log.info("Put {} items into {} buckets", (Object)Y.size(), (Object)this.buckets.size());
        this.newItems = new FastIDSet();
    }

    private static double[] findMean(FastByIDMap<float[]> Y, int features) {
        double[] theMeanVector = new double[features];
        for (FastByIDMap.MapEntry<float[]> entry : Y.entrySet()) {
            float[] vec = entry.getValue();
            for (int i = 0; i < features; ++i) {
                int n = i;
                theMeanVector[n] = theMeanVector[n] + (double)vec[i];
            }
        }
        int size = Y.size();
        int i = 0;
        while (i < features) {
            int n = i++;
            theMeanVector[n] = theMeanVector[n] / (double)size;
        }
        return theMeanVector;
    }

    private long toBitSignature(float[] vector) {
        long l = 0L;
        double[] theMeanVector = this.meanVector;
        for (boolean[] randomVector : this.randomVectors) {
            double total = 0.0;
            for (int i = 0; i < randomVector.length; ++i) {
                double delta = (double)vector[i] - theMeanVector[i];
                if (randomVector[i]) {
                    total += delta;
                    continue;
                }
                total -= delta;
            }
            if (total > 0.0) {
                l = l << 1 | 1L;
                continue;
            }
            l <<= 1;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Iterator<FastByIDMap.MapEntry<float[]>>> getCandidateIterator(float[][] userVectors) {
        long[] bitSignatures = new long[userVectors.length];
        for (int i = 0; i < userVectors.length; ++i) {
            bitSignatures[i] = this.toBitSignature(userVectors[i]);
        }
        ArrayList<Iterator<FastByIDMap.MapEntry<float[]>>> inputs = Lists.newArrayList();
        block4: for (FastByIDMap.MapEntry<long[]> entry : this.buckets.entrySet()) {
            for (long bitSignature : bitSignatures) {
                if (Long.bitCount(bitSignature ^ entry.getKey()) > this.maxBitsDiffering) continue;
                inputs.add(new IDArrayToEntryIterator(entry.getValue()));
                continue block4;
            }
        }
        FastIDSet fastIDSet = this.newItems;
        synchronized (fastIDSet) {
            if (!this.newItems.isEmpty()) {
                inputs.add(new IDToEntryIterator(this.newItems.clone().iterator()));
            }
        }
        return inputs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addItem(long itemID) {
        if (this.newItems != null) {
            FastIDSet fastIDSet = this.newItems;
            synchronized (fastIDSet) {
                this.newItems.add(itemID);
            }
        }
    }

    static {
        Preconditions.checkArgument(LSH_SAMPLE_RATIO > 0.0 && LSH_SAMPLE_RATIO <= 1.0, "Bad LSH ratio: %s", LSH_SAMPLE_RATIO);
        Preconditions.checkArgument(NUM_HASHES >= 1 && NUM_HASHES <= 64, "Bad # hashes: %s", NUM_HASHES);
    }

    private static final class MutableMapEntry
    implements FastByIDMap.MapEntry<float[]> {
        private long key;
        private float[] value;

        private MutableMapEntry() {
        }

        @Override
        public long getKey() {
            return this.key;
        }

        @Override
        public float[] getValue() {
            return this.value;
        }

        public void set(long key, float[] value) {
            this.key = key;
            this.value = value;
        }
    }

    private final class IDArrayToEntryIterator
    implements Iterator<FastByIDMap.MapEntry<float[]>> {
        private int offset;
        private final long[] input;
        private final MutableMapEntry delegate;

        private IDArrayToEntryIterator(long[] input) {
            this.input = input;
            this.delegate = new MutableMapEntry();
        }

        @Override
        public boolean hasNext() {
            return this.offset < this.input.length;
        }

        @Override
        public FastByIDMap.MapEntry<float[]> next() {
            long itemID = this.input[this.offset++];
            this.delegate.set(itemID, (float[])LocationSensitiveHash.this.Y.get(itemID));
            return this.delegate;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private final class IDToEntryIterator
    implements Iterator<FastByIDMap.MapEntry<float[]>> {
        private final LongPrimitiveIterator input;
        private final MutableMapEntry delegate;

        private IDToEntryIterator(LongPrimitiveIterator input) {
            this.input = input;
            this.delegate = new MutableMapEntry();
        }

        @Override
        public boolean hasNext() {
            return this.input.hasNext();
        }

        @Override
        public FastByIDMap.MapEntry<float[]> next() {
            long itemID = this.input.nextLong();
            this.delegate.set(itemID, (float[])LocationSensitiveHash.this.Y.get(itemID));
            return this.delegate;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

