% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppw.R
\name{ppw.test}
\alias{ppw.test}
\title{Test for difference in left-censored samples}
\usage{
ppw.test(xd, xc, yd, yc, alternative = "two.sided", printstat = TRUE)
}
\arguments{
\item{xd}{The first column of data values plus detection limits}

\item{xc}{The column of censoring indicators, where 1 (or \code{TRUE}) indicates a detection limit in the xd column, and 0 (or \code{FALSE}) indicates a detected value in \code{xd}.}

\item{yd}{The second column of data values plus detection limits}

\item{yc}{The column of censoring indicators, where 1 (or \code{TRUE}) indicates a detection limit in the yd column, and 0 (or \code{FALSE}) indicates a detected value in \code{yd}}

\item{alternative}{The usual notation for the alternate hypothesis.  Default is \verb{“two.sided”}.  Options are \verb{“greater”} or \verb{“less”}.}

\item{printstat}{Logical \code{TRUE}/\code{FALSE} option of whether to print the resulting statistics in the console window, or not.  Default is \code{TRUE.}}
}
\value{
Paired Prentice-Wilcoxon test results including Z-statistic, n (sample size), p-value and median difference
}
\description{
Performs a nonparametric Paired Prentice-Wilcoxon test of whether the median difference between two columns of paired censored data equals 0 (O'Brien and Fleming, 1987)
}
\examples{
data(PbHeron)
ppw.test(PbHeron$Liver,PbHeron$LiverCen,PbHeron$Bone,PbHeron$BoneCen)

}
\references{
Helsel, D.R., 2011. Statistics for Censored Environmental Data using Minitab and R, 2nd ed. John Wiley & Sons, USA, N.J.

O’Brien, P.C., Fleming, T.R., 1987. A Paired Prentice-Wilcoxon Test for Censored Paired Data. Biometrics 43, 169–180. https://doi.org/10.2307/2531957
}
\seealso{
\link[survival:survfit]{survival::survfit} \link[survival:Surv]{survival::Surv}
}
