\name{oddratio}
\alias{oddratio}

\title{
Calculation of zeta (\eqn{\zeta})
}
\description{
 \eqn{\zeta}  is used to measure homogeneity intensity of two subdatasets.  If  \eqn{\zeta}  is larger than 1, these two subdatasets have good homogeneity; otherwise, \eqn{\zeta <1} indicates that two subdatasets have poor homogeneity (big noise).
}
\usage{
oddratio(XX, na, nb)
}

\arguments{
  \item{XX}{
nonnegative count data of RNA reads generated by next generation sequencing.
}
  \item{na}{
number of replicate libraries in condition A.
}
  \item{nb}{
number of replicate libraries in condition B.
}
}
\details{
 Zeta (\eqn{\zeta}) is defined as 
%\deqn{\zeta=ln\left(1+\frac{\bar{X}\times \sigma^2+1}{\bar{X}_A \times \sigma^2_A+\bar{X}_B\times \sigma^2_B\right)+1}}
\deqn{\zeta=ln\left(1+\frac{\bar{X} \times \sigma^2 +1}{\bar{X}_A\times \sigma^2_A+\bar{X}_B\times \sigma^2_B+1}\right) }
where
\eqn{\zeta} is different from \eqn{\psi}. If two subdatasets have big a 
gap and good homogeneity,then seta value has much larger than 1.
 
}
\value{

zeta vector.

}

\references{
Yuan-De Tan Anita M. Chandler, Arindam Chaudhury, and Joel R. Neilson(2015)  A Powerful Statistical Approach for Large-scale Differential Transcription Analysis.  \emph{Plos One}. 2015 DOI: 10.1371/journal.pone.0123658. 
}
\author{
Yuan-De Tan
\email{tanyuande@gmail.com}
}


\seealso{
    \code{\link{pratio}}, \code{\link{mbetattest}}.
}
\examples{
XX<-matrix(NA,2,8)
XX[1,]<-c(112,122, 108,127,302, 314, 322, 328)
XX[2,]<-c(511, 230, 754, 335,771, 842, 1014,798)
oddratio(XX=XX,na=4,nb=4)
}
\keyword{ homogeneity }
\keyword{gap}
