% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_functions.R
\name{convert_POSIXct_to_NEONhdf5_time}
\alias{convert_POSIXct_to_NEONhdf5_time}
\title{Convert a POSIXct object to the format used in NEON HDF5 files}
\usage{
convert_POSIXct_to_NEONhdf5_time(intime)
}
\arguments{
\item{intime}{POSIXct vector to convert to NEON time format.}
}
\value{
Returns character version of POSIXct object
matching NEON time variable format.
}
\description{
Converts a POSIXct object back to the character format used by NEON in their
HDF eddy covariance files. Output format, using strptime syntax, is
\%Y-\%m-\%dT\%H:\%M:\%OSZ.
}
\examples{
convert_POSIXct_to_NEONhdf5_time(Sys.time())
}
\author{
Rich Fiorella \email{rfiorella@lanl.gov}
}
