% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KF-dependencies.R
\name{A_T}
\alias{A_T}
\title{Calculate \eqn{A(T)}}
\usage{
A_T(parameters, Tt)
}
\arguments{
\item{parameters}{A named vector of parameters of an N-factor model. Function \code{NFCP.Parameters} is recommended.}

\item{Tt}{A vector or matrix of the time-to-maturity of observed futures prices}
}
\value{
A matrix of identical dimensions to \eqn{T} providing the values of function \eqn{A(T)} of a given N-factor model and observations.
}
\description{
Calculate the values of \eqn{A(T)} for a given N-factor model parameters and observations. Primarily purpose is for application within other functions of the \code{NFCP} package.
}
\details{
\loadmathjax
Under the assumption that Factor 1 follows a Brownian Motion, \eqn{A(T)} is given by:
\mjdeqn{A(T) = \mu^*T-\sum_{i=1}^N - \frac{1-e^{-\kappa_i T}\lambda_i}{\kappa_i}+\frac{1}{2}(\sigma_1^2T +
\sum_{i.j\neq 1} \sigma_i \sigma_j \rho_{i,j} \frac{1-e^{-(\kappa_i+\kappa_j)T}}{\kappa_i+\kappa_j})}{A(T) = mu^* * T - sum_{i=1}^N (1-e^(-kappa[i] T)lambda[i])/(kappa[i]) + 1/2 (sigma[1]^2 * T)
+ sum_{i.j != 1} sigma[i] sigma[j] rho[i,j] (1 - e^(-(kappa[i] + kappa[j]) * T)) / (kappa[i] + kappa[j])}
}
\examples{
##Calculate time homogeneous values of A(T) for the
##Schwartz and Smith (2000) two-factor model:
SS.Oil.A_T <- A_T(SS.Oil$Two.Factor, SS.Oil$Stitched.TTM)

}
\references{
Schwartz, E. S., and J. E. Smith, (2000). Short-Term Variations and Long-Term Dynamics in Commodity Prices. \emph{Manage. Sci.}, 46, 893-911.

Cortazar, G., and L. Naranjo, (2006). An N-factor Gaussian model of oil futures prices. \emph{Journal of Futures Markets: Futures, Options, and Other Derivative Products}, 26(3), 243-268.
}
