% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NMreadSection.R
\name{NMreadSection}
\alias{NMreadSection}
\alias{NMgetSection}
\title{Extract sections of Nonmem control streams}
\usage{
NMreadSection(
  file = NULL,
  lines = NULL,
  text = NULL,
  section,
  return = "text",
  keepEmpty = FALSE,
  keepName = TRUE,
  keepComments = TRUE,
  asOne = TRUE,
  simplify = TRUE,
  cleanSpaces = FALSE,
  ...
)

NMgetSection(...)
}
\arguments{
\item{file}{A file path to read from. Normally a .mod or .lst. See
lines also.}

\item{lines}{Text lines to process. This is an alternative to
using the file argument.}

\item{text}{Use this argument if the text to process is one long
character string, and indicate the line separator with the
linesep argument (handled by NMextractText). Use only one of
file, lines, and text.}

\item{section}{The name of section to extract without
"$". Examples: "INPUT", "PK", "TABLE", etc. Not case
sensitive.}

\item{return}{If "text", plain text lines are returned. If "idx",
matching line numbers are returned. "text" is default.}

\item{keepEmpty}{Keep empty lines in output? Default is FALSE.}

\item{keepName}{Keep the section name in output (say, "$PROBLEM")
Default is TRUE. It can only be FALSE, if return"idx".}

\item{keepComments}{Keep comment lines?}

\item{asOne}{If multiple hits, concatenate into one. This will
most often be relevant with name="TABLE". If FALSE, a list
will be returned, each element representing a table. Default
is TRUE. So if you want to process the tables separately, you
probably want FALSE here.}

\item{simplify}{If asOne=FALSE, do you want the result to be
simplified if only one section is found? Default is TRUE which
is desirable for interactive analysis. For programming, you
probably want FALSE.}

\item{cleanSpaces}{If TRUE, leading and trailing are removed, and
multiplied succeeding white spaces are reduced to single white
spaces.}

\item{...}{Additional arguments passed to NMextractText}
}
\value{
character vector with extracted lines.
}
\description{
This is a very commonly used wrapper for the input part of the
model file. Look NMextractText for more general functionality
suitable for the results part too.
}
\section{Functions}{
\itemize{
\item \code{NMgetSection}: Deprecated function name. Use NMreadSection.
}}

\examples{
NMreadSection(system.file("examples/nonmem/xgxr001.lst", package="NMdata"),section="DATA")

}
\seealso{
Other Nonmem: 
\code{\link{NMapplyFilters}()},
\code{\link{NMextractText}()},
\code{\link{NMgenText}()},
\code{\link{NMwriteData}()},
\code{\link{NMwriteSection}()}
}
\concept{Nonmem}
