% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/egdt.R
\name{egdt}
\alias{egdt}
\title{Expand grid of data.tables}
\usage{
egdt(dt1, dt2, quiet)
}
\arguments{
\item{dt1}{a data.table.}

\item{dt2}{another data.table.}

\item{quiet}{The default is to give some information along the way
on what data is found. But consider setting this to TRUE for
non-interactive use. Default can be configured using
NMdataConf.}
}
\value{
a data.table that expands combinations of rows in dt1 and
    dt2.
}
\description{
Expand grid of data.tables
}
\details{
Merging works mostly similarly for data.table and
    data.table. However, for data.table the merge must be done by
    one or more columns. This means that the convenient way to
    expand all combinations of all rows in two data.frames is not
    available for data.tables. This functions provides that
    functionality. It always returns data.tables.
}
\examples{
df1 <- data.frame(a=1:2,b=3:4)
df2 <- data.frame(c=5:6,d=7:8)
merge(df1,df2)
library(data.table)
## This is not possible
\dontrun{
merge(as.data.table(df1),as.data.table(df2),allow.cartesian=TRUE)
}
## Use egdt instead
egdt(as.data.table(df1),as.data.table(df2))
}
