% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NMwriteSection.R
\name{NMwriteSection}
\alias{NMwriteSection}
\title{Replace ($)sections of a Nonmem control stream}
\usage{
NMwriteSection(
  files,
  file.pattern,
  dir,
  section,
  newlines,
  list.sections,
  location = "replace",
  newfile,
  backup = TRUE,
  blank.append = TRUE,
  data.file,
  write = TRUE,
  quiet,
  simplify = TRUE
)
}
\arguments{
\item{files}{File paths to the models (control stream) to
edit. See file.pattern too.}

\item{file.pattern}{Alternatively to files, you can supply a
regular expression which will be passed to list.files as the
pattern argument. If this is used, use `dir` argument as
well. Also see data.file to only process models that use a
specific data file.}

\item{dir}{If file.pattern is used, `dir` is the directory to search
in.}

\item{section}{The name of the section to update with or without
"$". Example: `section="EST"` or `section="$EST"` to edit the
sections starting by `$EST`. Section specification is not
case-sensitive. See `?NMreadSection` too.}

\item{newlines}{The new text (including "$SECTION"). Better be
broken into lines in a character vector since this is simply
past to \code{writeLines()}.}

\item{list.sections}{Named list of new sections, each element
containing a section. Names must be section names, contents of
each element are the new section lines for each section.}

\item{location}{In combination with `section`, this determines
where the new section is inserted. Possible values are
"replace" (default), "before", "after", "first", "last".}

\item{newfile}{path and filename to new run. If missing, the
original file (from \code{files} or \code{file.pattern}) is
overwritten (see the \code{backup} option below). If NULL,
output is returned as a character vector rather than written.}

\item{backup}{In case you are overwriting the old file, do you
want to backup the file (to say, backup_run001.mod)?}

\item{blank.append}{Append a blank line to output?}

\item{data.file}{Use this to limit the scope of models to those
that use a specific input data data file. The string has to
exactly match the one in `$DATA` or `$INFILE` in Nonmem.}

\item{write}{Default is to write to file. If write=FALSE,
`NMwriteSection()` returns the resulting input.txt without writing
it to disk.  Default is `TRUE`.}

\item{quiet}{The default is to give some information along the way
on what data is found. But consider setting this to TRUE for
non-interactive use. Default can be configured using
`NMdataConf()`.}

\item{simplify}{If TRUE (default) and only one file is edited, the
resulting rows are returned directly. If more than one file is
edited, the result will always be a list with one element per
file.}
}
\value{
The new section text is returned. If write=TRUE, this is
    done invisibly.
}
\description{
Just give the section name, the new lines and the file path, and the
"$section", and the input to Nonmem will be updated.
}
\details{
The new file will be written with unix-style line
    endings.
}
\examples{
newlines <- "$EST POSTHOC INTERACTION METHOD=1 NOABORT PRINT=5 MAXEVAL=9999 SIG=3"
NMwriteSection(files=system.file("examples/nonmem/xgxr001.mod", package = "NMdata"),
section="EST", newlines=newlines,newfile=NULL)
\dontrun{
text.nm <- NMwriteData(data)
NMwriteSection(dir="nonmem",
              file.pattern="^run.*\\\\.mod",
              list.sections=text.nm["INPUT"])
}
}
\seealso{
Other Nonmem: 
\code{\link{NMapplyFilters}()},
\code{\link{NMextractText}()},
\code{\link{NMgenText}()},
\code{\link{NMreadSection}()},
\code{\link{NMreplaceDataFile}()}
}
\concept{Nonmem}
