% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_project.R
\name{nm_create_analysis_project}
\alias{nm_create_analysis_project}
\title{Create analysis project}
\usage{
nm_create_analysis_project(
  path,
  dirs = nm_default_dirs(),
  style = c("analysis", "analysis-package"),
  use_renv = FALSE,
  readme_template_package = "NMproject",
  ...
)
}
\arguments{
\item{path}{Character path (relative or absolute) to project.  If just
specifying a name, this will create the analysis project in the current
working directory.  See details for naming requirements.}

\item{dirs}{Character list or vector.  Default = \code{nm_default_dirs()}.  Can
also handle an ordered string which is supplied by the RStudio project
template interface.}

\item{style}{Character. Either \code{"analysis"} or \code{"analysis-package"} See
details for \code{path} requirements and function behaviour.}

\item{use_renv}{Logical (default = \code{FALSE}). Should \code{renv} be used or not in
project.}

\item{readme_template_package}{Package name from which to load the README
template (default = \code{"NMproject"})}

\item{...}{Deprecated.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

This is the underlying function used by: \code{File} -> \verb{New Project} ->
\verb{New Directory} -> \verb{New NMproject}.  It creates a new analysis working
directory with a directory structure similar to an R package.
}
\details{
The function works like as is inspired by
\code{starters::create_analysis_project()}. There is no restriction on directory
name.  It is therefore possible to violate R package naming conventions.

When \code{style = "analysis"} is selected, the analysis directory will be
package-like in structure, with the package name \code{"localanalysis"}.
For \code{style = "analysis-package"}, \code{path} should contain only (ASCII)
letters, numbers and dot, have at least two characters and start with a
letter and not end in a dot.  See \href{https://cran.r-project.org/doc/manuals/r-release/R-exts.html#The-DESCRIPTION-file}{Description file requirements}
for more information.

This is to cater to users who like underscores and aren't interested in
creating a package.
}
\section{Default modelling directories}{


Default modelling directories can be modified with \code{nm_default_dirs} option
(see \code{\link[=options]{options()}} for information on how to modify this). A (partially) named
list of directories to be used by \code{nm_create_analysis_project} Required names
are \code{"models"}, \code{"scripts"} and \code{"results"}. By default these are set to
\code{"Models"}, \code{"Scripts"} and \code{"Results"}, respectively. Additional nameless
characters (e.g. \code{"SourceData"}) correspond to additional modelling
directories.

\describe{
\item{"SourceData":}{
intended for unmodified source datasets entering the analysis project.
}
\item{"DerivedData":}{
intended for cleaned and processed NONMEM ready datasets
}
\item{"Scripts":}{
intended for all R scripts
}
\item{"Models":}{
intended for all NONMEM modelling
}
\item{"Results":}{
intended as default location for run diagnostics, plots and tables
}
}
}

\seealso{
\code{\link[=nm_default_dirs]{nm_default_dirs()}} for modifying default directory structure.
}
