% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Regression.R
\name{VN.reg}
\alias{VN.reg}
\title{VN Regression}
\usage{
VN.reg(x, y, order = max(2, ceiling(VN.dep(x, y) *
  ceiling(log10(length(x))))), point.est = NULL, location = "top",
  print.values = FALSE)
}
\arguments{
\item{x}{Independent Variable}

\item{y}{Dependent Variable}

\item{order}{Controls the number of partial moment quadrant means.  Defaults to smaller order to avoid overfitting}

\item{point.est}{Returns the fitted value for any value of the independent variable}

\item{location}{Sets the legend location within the plot}

\item{print.values}{Defaults to FALSE, set to TRUE in order to return all fitted values for independent variable}
}
\description{
Generates a nonlinear regression based on partial moment quadrant means.
}
\examples{
set.seed(123)
x<-rnorm(100); y<-rnorm(100)
\dontrun{VN.reg(x,y)}
}
\keyword{nonlinear}
\keyword{regression}

