% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ARMA.R
\name{NNS.ARMA}
\alias{NNS.ARMA}
\title{NNS ARMA}
\usage{
NNS.ARMA(variable, h = 1, Training_set = NULL, Seasonal_Factor = TRUE,
  Negative_Values = FALSE, Linear = TRUE, Dynamic = FALSE, s.t.n = 0.9)
}
\arguments{
\item{variable}{Variable}

\item{h}{Number of periods to forecast, defaults to 1.}

\item{Training_set}{Sets the number of observations from 1:xx to monitor performance of forecast over in-sample range. Defaults to NULL to use all observations.}

\item{Seasonal_Factor}{Automatically selects the best seasonal lag from the seasonality test.  Defaults to TRUE.  To use weighted average of all seasonal lags set to FALSE.  Otherwise, input integer lag to use, i.e. \code{Seasonal_Factor=12} for monthly data.}

\item{Negative_Values}{If the variable can be negative, set to TRUE.  Defaults to FALSE.}

\item{Linear}{To use a linear regression of the component series, defaults to TRUE.  To use a nonlineaer regression, set to FALSE.}

\item{Dynamic}{To update the seasonal factor with each forecast point, set to TRUE.  The default is FALSE to keep the original seasonal factor from the inputted variable for all forecasts.}

\item{s.t.n}{Signal to noise parameter, sets the threshold of \code{NNS.dep} which reduces \code{"order"} when \code{order=NULL}.  Defaults to 0.9 to ensure high dependence for higher \code{"order"} and endpoint determination.}
}
\value{
Returns a vector of forecasts of length \code{(h)}.
}
\description{
Autoregressive model incorporating nonlinear regressions of component series.
}
\examples{
set.seed(123)
x<-rnorm(100)
NNS.ARMA(x)
}
\author{
Fred Viole, OVVO Financial Systems
}
\references{
Viole, F. and Nawrocki, D. (2013) "Nonlinear Nonparametric Statistics: Using Partial Moments"
\url{http://amzn.com/1490523995}
}
\keyword{Autoregressive}
\keyword{model}

