% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FSD.R
\name{NNS.FSD}
\alias{NNS.FSD}
\title{NNS FSD Test}
\usage{
NNS.FSD(x, y, type = "discrete")
}
\arguments{
\item{x}{a numeric vector.}

\item{y}{a numeric vector.}

\item{type}{options: ("discrete", "continuous"); \code{"discrete"} (default) selects the type of CDF.}
}
\value{
Returns one of the following FSD results: \code{"X FSD Y"}, \code{"Y FSD X"}, or \code{"NO FSD EXISTS"}.
}
\description{
Bi-directional test of first degree stochastic dominance using lower partial moments.
}
\examples{
set.seed(123)
x <- rnorm(100) ; y<-rnorm(100)
NNS.FSD(x, y)
}
\references{
Viole, F. and Nawrocki, D. (2016) "LPM Density Functions for the Computation of the SD Efficient Set." Journal of Mathematical Finance, 6, 105-126. \url{http://www.scirp.org/Journal/PaperInformation.aspx?PaperID=63817}.

Viole, F. (2017) "A Note on Stochastic Dominance." \url{https://ssrn.com/abstract=3002675}.
}
\author{
Fred Viole, OVVO Financial Systems
}
\keyword{dominance}
\keyword{stochastic}
