% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{D.LPM}
\alias{D.LPM}
\title{Divergent‑Lower Partial Moment}
\usage{
D.LPM(degree_lpm, degree_upm, x, y, target_x, target_y)
}
\arguments{
\item{degree_lpm}{numeric; LPM degree = 0 gives frequency, = 1 gives area.}

\item{degree_upm}{numeric; UPM degree = 0 gives frequency, = 1 gives area.}

\item{x}{numeric vector of observations.}

\item{y}{numeric vector of the same length as x.}

\item{target_x}{numeric vector; thresholds for x (defaults to mean(x)).}

\item{target_y}{numeric vector; thresholds for y (defaults to mean(y)).}
}
\value{
Numeric vector of divergent LPM values.
}
\description{
Computes the divergent lower partial moment (lower‑right quadrant 3)
  between two equal‑length numeric vectors.
}
\examples{
  set.seed(123)
  x <- rnorm(100); y <- rnorm(100)
  D.LPM(0, 0, x, y, mean(x), mean(y))
}
\references{
Viole, F. & Nawrocki, D. (2013) *Nonlinear Nonparametric Statistics: Using Partial Moments* (ISBN:1490523995)
}
\author{
Fred Viole, OVVO Financial Systems
}
