% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{mmNiWpdfC}
\alias{mmNiWpdfC}
\title{C++ implementation of multivariate Normal inverse Wishart probability density function for multiple inputs}
\usage{
mmNiWpdfC(Mu, Sigma, U_Mu0, U_Kappa0, U_Nu0, U_Sigma0, Log = TRUE)
}
\arguments{
\item{Mu}{data matrix of dimension \code{p x n}, \code{p} being the dimension of the
data and n the number of data points, where each column is an observed mean vector.}

\item{Sigma}{list of length \code{n} of observed variance-covariance matrices,
each of dimensions \code{p x p}.}

\item{U_Mu0}{mean vectors matrix of dimension \code{p x K}, \code{K} being the number of
distributions for which the density probability has to be evaluated}

\item{U_Kappa0}{vector of length \code{K} of scale parameters.}

\item{U_Nu0}{vector of length \code{K} of degree of freedom parameters.}

\item{U_Sigma0}{list of length \code{K} of variance-covariance matrices,
each of dimensions \code{p x p}.}

\item{Log}{logical flag for returning the log of the probability density
function. Defaults is \code{TRUE}.}
}
\value{
matrix of densities of dimension K x n
}
\description{
C++ implementation of multivariate Normal inverse Wishart probability density function for multiple inputs
}
\references{
Hejblum BP, Alkhassim C, Gottardo R, Caron F, Thiebaut R, Sequential Dirichlet
Process Mixtures of Multivariate Skew t-distributions for Model-based Clustering
of Flow Cytometry Data, submitted.
arxiv ID: 1702.04407 \url{https://arxiv.org/abs/1702.04407v2}
}
