% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_table_info.R
\name{get_table_info}
\alias{get_table_info}
\title{Detailed Information about a Table and Its Classification on the API opendata.1212.mn}
\usage{
get_table_info(tbl_id)
}
\arguments{
\item{tbl_id}{character string, Table identification number}
}
\value{
list, Table information and classification. It has following structure:
\describe{
 \item{tbl_id}{Table identification number}
 \item{unit_id}{Unit identification number}
 \item{unit_nm}{Unit name in Mongolia}
 \item{unit_eng_nm}{Unit name in English}
 \item{obj}{Table classification:
  \describe{
   \item{obj_var_id}{Variable identification}
   \item{var_ord_sn}{Variable identification number}
   \item{field}{Field name}
   \item{scr_mn}{Variable name in Mongolian}
   \item{scr_eng}{Variable identification}
   \item{itm}{Variable classification and code:
    \describe{
     \item{itm_id}{Classification number}
     \item{up_itm_id}{Sub-classification}
     \item{scr_mn}{Classification name in Mongolian}
     \item{scr_eng}{Classification name in English}
    }
   }
  }
 }
}
}
\description{
Detailed information about a table and its classification on the API \url{opendata.1212.mn} is supported by National Statistical Office of Mongolia (NSO)
}
\examples{
table_info <- get_table_info("DT_NSO_2400_015V2")
table_info$unit_nm
table_info$obj[[1]]$itm[[1]]$scr_mn
}
\references{
\url{http://opendata.1212.mn/en/doc/Api/GET-api-Itms-id}
}
\seealso{
\link{all_tables}, \link{get_table}, \link{get_sector_info}
}
