% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{Sstep.Sonar}
\alias{Sstep.Sonar}
\title{Sequential Importance Sampling Step for A Target with Passive Sonar}
\usage{
Sstep.Sonar(mm, xx, logww, yy, par, xdim = 1, ydim = 1)
}
\arguments{
\item{mm}{the Monte Carlo sample size \code{m}.}

\item{xx}{the sample in the last iteration.}

\item{logww}{the log weight in the last iteration.}

\item{yy}{the observations with \code{T} columns and \code{ydim} rows.}

\item{par}{a list of parameter values. \code{H} is the state coefficient matrix, \code{W*t(W)} is the state innovation covariance matrix,
\code{V*t(V)} is the covariance matrix of the observation noise, \code{s2} is the second sonar location.}

\item{xdim}{the dimension of the state varible \code{x_t}.}

\item{ydim}{the dimension of the observation \code{y_t}.}
}
\value{
The function returns a list with the following components:
\item{xx}{the new sample.}
\item{logww}{the log weights.}
}
\description{
This function implements one step of the sequential importance sampling method for a target with passive sonar.
}
\references{
Tsay, R. and Chen, R. (2019). Nonlinear Time Series Analysis. Wiley, New Jersey.
}
