% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runparallelNUCOM.r
\name{runparallelNUCOM}
\alias{runparallelNUCOM}
\title{Run parallel NUCOM}
\source{
The executable and the source code of the model can downloaded from \url{https://github.com/jeroenpullens/NUCOMBog}.
}
\usage{
runparallelNUCOM(setup, clustertype, numCores = 1, parameters)
}
\arguments{
\item{setup}{The setup needs to be made before by running the setup_NUCOM function.}

\item{clustertype}{Clustertype: The model has only been tested on SOCK cluster, which is the set to default.}

\item{numCores}{Number of Cores on which are model needs to be run (NOTE: Non-parallel runs can only be run on 1 core). Default is 1.}

\item{parameters}{The parameters which are used in the model. If no parameter values are given the default values will be used. The parameters have to have the format of a dataframe with colum names: "names" and "values". The default parameters are from Heijmans et al. 2008.}
}
\description{
Code to run NUCOMBog parallel on multiple cores.
}
\examples{
\dontrun{
!!the variable "test_setup" is from the function setupNUCOM, see the help for more information!!

parallel<-runparallelNUCOM(setup = test_setup,
                            clustertype = "SOCK",
                            numCores = 1,
                            parameters=initialParameters)
}
}
\author{
JWM Pullens
}
\references{
Heijmans, M., Mauquoy, D., van Geel, B., and Berendse, F. (2008). Long-term effects of climate change on vegetation and carbon dynamics in peat bogs. Journal of Vegetation Science, 19(3)
}
\keyword{NUCOMBog}

