% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upsample.R
\name{upsample}
\alias{upsample}
\title{Up sample}
\usage{
upsample(x, condition, .name = "condition")
}
\arguments{
\item{x}{A data.frame or something coercible to one}

\item{condition}{A character vector the same length as 'x' denoting which
condition each observation belongs to}

\item{.name}{A string used to name the condition column}
}
\value{
A tibble
}
\description{
Randomly up-sample the minority condition(s) to have the same number of
observations as the majority condition. Random samples are added to the
existing observations of the minority conditions
}
\examples{
d <- data.frame(
  condition = c(rep("a", times = 7), rep("b", times = 3)),
  x = sample(0:1, size = 10, replace = TRUE),
  y = sample(0:1, size = 10, replace = TRUE)
)

upsample(x = d, condition = d$condition)
}
