% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/turtle-functions.R
\name{downhill}
\alias{downhill}
\alias{downhill,worldMatrix,missing,agentMatrix,numeric-method}
\alias{downhill,worldArray,character,agentMatrix,numeric-method}
\title{Move downhill}
\usage{
downhill(world, pVar, turtles, nNeighbors, torus = FALSE)

\S4method{downhill}{worldMatrix,missing,agentMatrix,numeric}(world, turtles, nNeighbors, torus)

\S4method{downhill}{worldArray,character,agentMatrix,numeric}(world, pVar, turtles, nNeighbors, torus = FALSE)
}
\arguments{
\item{world}{\code{WorldMatrix} or \code{worldArray} object.}

\item{pVar}{Character. If the \code{world} is a \code{worldArray} object, \code{pVar}
is the name of the layer to use to define the \code{patches} values.
\code{pVar} must not be provided if the \code{world} is a \code{worldMatrix} object.}

\item{turtles}{\code{AgentMatrix} object representing the moving \code{agents}.}

\item{nNeighbors}{Integer: 4 or 8. Represents the number of neighbor \code{patches}
considered.}

\item{torus}{Logical to determine if the \code{world} is wrapped. Default is
\code{torus = FALSE}.}
}
\value{
\code{AgentMatrix} representing the \code{turtles} with updated
coordinates and updated data for their \code{heading} values and
previous coordinates \code{prevX}
and \code{prevY}.
}
\description{
Move the \code{turtles} to their neighboring patch with the lowest value.
}
\details{
If no neighboring \code{patch} has a smaller value than the \code{patch} where the
\code{turtle} is currently located on, the \code{turtle} stays on this \code{patch}. It still
moves to the \code{patch} center if it was not already on it.

\if{html}{\out{<div class="sourceCode">}}\preformatted{     If there are multiple neighboring `patches` with the same lowest value,
     the `turtle` chooses one `patch` randomly.

     If a `turtle` is located on a `patch` on the edge
     of the `world` and `torus = FALSE`, it has fewer
     neighboring `patches` as options to move than `nNeighbors`; if
     `torus = TRUE`, the `turtle` can move on the other side of the `world` to
     move downhill and its choice of neighboring `patches` is always equals to
     `nNeighbors`.
}\if{html}{\out{</div>}}
}
\examples{
w1 <- createWorld(minPxcor = 1, maxPxcor = 10, minPycor = 1, maxPycor = 10,
                          data = runif(100))
t1 <- createTurtles(n = 10, coords = randomXYcor(w1, n = 10))
plot(w1)
points(t1, col = of(agents = t1, var = "color"), pch = 16)

t1 <- downhill(world = w1, turtles = t1, nNeighbors = 8)
points(t1, col = of(agents = t1, var = "color"), pch = 16)


}
\references{
Wilensky, U. 1999. NetLogo. http://ccl.northwestern.edu/netlogo/.
Center for Connected Learning and Computer-Based Modeling,
Northwestern University. Evanston, IL.
}
\seealso{
\url{https://ccl.northwestern.edu/netlogo/docs/dictionary.html#downhill}
}
\author{
Sarah Bauduin
}
